/*
 * Copyright (c) 2019-2026 Actinius
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "accelerometer.h"

#include <zephyr/drivers/sensor.h>

#define ACCEL_NODE DT_ALIAS(accel0)

static const struct device *accel;

bool init_accelerometer(void)
{
	accel = DEVICE_DT_GET(ACCEL_NODE);

	if (!device_is_ready(accel)) {
		printk("Error: accelerometer device not ready\n");
		return false;
	}

	return true;
}

void get_accelerometer_data(double *x_accel, double *y_accel, double *z_accel)
{
	struct sensor_value value_x, value_y, value_z;

	sensor_sample_fetch(accel);

	sensor_channel_get(accel, SENSOR_CHAN_ACCEL_X, &value_x);
	*x_accel = sensor_value_to_double(&value_x);

	sensor_channel_get(accel, SENSOR_CHAN_ACCEL_Y, &value_y);
	*y_accel = sensor_value_to_double(&value_y);

	sensor_channel_get(accel, SENSOR_CHAN_ACCEL_Z, &value_z);
	*z_accel = sensor_value_to_double(&value_z);
}
