/*
 * Copyright (c) 2019-2026 Actinius
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "accelerometer.h"

#include <stdio.h>

#ifdef CONFIG_ACTINIUS_ACCEL_USE_ANSI
/* ANSI escape codes for terminal control */
#define ANSI_CURSOR_HOME "\033[1;1H"
#define ANSI_CLEAR_SCREEN "\033[2J"
#endif

int main(void)
{
	if (!init_accelerometer()) {
		return -1;
	}

	while (1) {
#ifdef CONFIG_ACTINIUS_ACCEL_USE_ANSI
		printk(ANSI_CURSOR_HOME);
		printk(ANSI_CLEAR_SCREEN);
#endif

		double x_accel = 0;
		double y_accel = 0;
		double z_accel = 0;

		get_accelerometer_data(&x_accel, &y_accel, &z_accel);

		printk("Acceleration values:\n");
		printk("-------------------------------------------------------------------------------\n");
		printf("X: %lf (m/s^2), Y: %lf (m/s^2), Z: %lf (m/s^2)\n",
		       x_accel, y_accel, z_accel);
		printk("-------------------------------------------------------------------------------\n");

		k_sleep(K_MSEC(200));
	}

	return 0;
}
