#
# Copyright (c) 2024-2026 Actinius
#
# SPDX-License-Identifier: BSD-3-Clause
#

# This file should be included from each sample's sysbuild.cmake to set up
# the static partition manager configuration for Actinius boards.
#
# In sysbuild, BOARD contains the board name and BOARD_QUALIFIERS contains
# the SoC/variant qualifiers (e.g., /nrf9160/ns).

if(NOT DEFINED PM_STATIC_YML_FILE)
  # Construct the full board target
  set(_board_target "${BOARD}${BOARD_QUALIFIERS}")

  # Convert to filename format (replace / with _)
  string(REPLACE "/" "_" _board_filename "${_board_target}")

  # Path to pm_static files (in common/ directory)
  set(_pm_static_file "${CMAKE_CURRENT_LIST_DIR}/pm_static_${_board_filename}.yml")

  if(EXISTS "${_pm_static_file}")
    set(PM_STATIC_YML_FILE ${_pm_static_file} CACHE INTERNAL "")
    message(STATUS "Actinius: Using static partition layout: ${_pm_static_file}")
  endif()
endif()
